package ch.frankel.blog.jaxb;

import java.util.Calendar;
import java.util.Date;

import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.XMLGregorianCalendar;

/**
 * Dummy abstract super class to show the use of a super-class in JAXB.
 * 
 * @author Nicolas Frankel
 * @since 17.06.2009
 * @version 1.0
 */
public class JaxbConverter {

	/**
	 * Converts a String representing a {@link XMLGregorianCalendar} to a
	 * {@link Date}.
	 * 
	 * @param xgc
	 *            String to convert from
	 * @return Computed date
	 */
	public static Date parseDate(String xgc) {

		return DatatypeConverter.parseDate(xgc).getTime();
	}

	/**
	 * Converts a {@link Date} to a String representing a
	 * {@link XMLGregorianCalendar}.
	 * 
	 * @param date
	 *            Date to convert from
	 * @return String representation
	 */
	public static String printDate(Date date) {

		Calendar calendar = Calendar.getInstance();

		calendar.setTime(date);

		return DatatypeConverter.printDate(calendar);
	}
}
